class OnOffOnSwitch {
  public:
    OnOffOnSwitch(int leftpin, int rightpin) {
      this->leftpin = leftpin;
      this->rightpin = rightpin;
    }
    int leftpin;
    int rightpin;
    int mode;
    void setup();
    void read();
};



void OnOffOnSwitch::setup() {
  pinMode(this->leftpin, INPUT_PULLUP);
  pinMode(this->rightpin, INPUT_PULLUP);
}


// Reads the mode switch, a tri-state On-Off-On toggle switch
// Assign the resulting mode to the mode_selection variable
void OnOffOnSwitch::read() {
  bool left = digitalRead(this->leftpin);
  bool right = digitalRead(this->rightpin);
  if (left && right) {
    // Center
    this->mode = 1;
  } else if (!left && right) {
    // Left
    this->mode = 2;
  } else if (left && !right) {
    // Right
    this->mode = 0;
  }
}