
class LPF {
  public:
    float frequency = 100.00;
    float resonance = 0.9;

    float render(float sample);
    void setFrequency(float frequency);
    void addFrequency(float frequency);
    void setResonance(float resonance);
    void reset();

  private:
    float feedback;
    float buf0 = 0.0;
    float buf1 = 0.0;
};


float LPF::render(float sample) {
  this->buf0 = this->buf0 + this->frequency * (sample - this->buf0 + this->feedback * (this->buf0 - this->buf1));
  this->buf1 = this->buf1 + this->frequency * (this->buf0 - this->buf1);
  return this->buf1;
}

void LPF::setFrequency(float frequency) {
  this->frequency = 2.0 * sin(PI * frequency / 32000.0);
  this->feedback = this->resonance + this->resonance / (1.0 - this->frequency);
}

void LPF::addFrequency(float frequency) {
  this->frequency += 2.0 * sin(PI * frequency / 32000.0);
  this->feedback = this->resonance + this->resonance / (1.0 - this->frequency);
}

void LPF::setResonance(float resonance) {
  this->resonance = resonance;
  this->feedback = this->resonance + this->resonance / (1.0 - this->frequency);
}

void LPF::reset() {
  this->buf0 = 0.0;
  this->buf1 = 0.0;
}



class HPF {
  public:
    float frequency = 100.00;
    float resonance = 0.9;

    float render(float sample);
    void setFrequency(float frequency);
    void addFrequency(float frequency);
    void setResonance(float resonance);
    void reset();

  private:
    float feedback;
    float buf0 = 0.0;
    float buf1 = 0.0;
};


float HPF::render(float sample) {
  this->buf0 = this->buf0 + this->frequency * (sample - this->buf0 + this->feedback * (this->buf0 - this->buf1));
  this->buf1 = this->buf1 + this->frequency * (this->buf0 - this->buf1);
  return sample - this->buf1;
}

void HPF::setFrequency(float frequency) {
  this->frequency = 2.0 * sin(PI * frequency / 32000.0);
  this->feedback = this->resonance + this->resonance / (1.0 - this->frequency);
}

void HPF::addFrequency(float frequency) {
  this->frequency += 2.0 * sin(PI * frequency / 32000.0);
  this->feedback = this->resonance + this->resonance / (1.0 - this->frequency);
}

void HPF::setResonance(float resonance) {
  this->resonance = resonance;
  this->feedback = this->resonance + this->resonance / (1.0 - this->frequency);
}

void HPF::reset() {
  this->buf0 = 0.0;
  this->buf1 = 0.0;
}



float saturate(float x) {
    return tanh(x);
}
