---
permalink: /index.html
layout: single
---

# RP2040 VCO

This is a simple digital VCO (**V**oltage **C**ontrolled **O**scillator) based on the Seeed XIAO using the RP2040 chip by the Raspberry Pi foundation. This project is a fork of the project by [BleepSound](https://github.com/BleepSound/rp2040-chord-vco), which is in turn a clone by the original project created by HAGIWO ([link](https://note.com/solder_state/n/n64b91a171218) in japanese).

The module uses mostly SMD components of size 0805.

The resulting module is meant to be used as part of a Eurorack modular synthesizer with a ±12 V⎓ power supply. Alternatively it can be used standalone by using a cheap DC-DC converter from Aliexpress.



## Hardware

- powered by ±12 V⎓ (Eurorack Standard)
- 4HP (~20mm) wide
- 3× Potentiometers/Knobs (one with additional CV input, labeled `INV`)
- 1× independent CV input (labeled `V/OCT`)
- 1× audio output (AC-coupled)
- 1× push button (momentary)
- 1× toggle switch (3 positions)

## Software

This is a digital module, as such one can modify and upload different variants of the original software. At the time there are two variants:

1. **polyphonic Chord VCO module with 8 different waveforms**
   With a built-in quantizer and automatic harmonics function, if you input a suitable CV, it will play a nice chord progression.
2. **Drum Module with 3 different Instruments (Kick/Snare/Hihat)**
   Trigger the drum via push-button or external gate signal. Use a the three knobs to change tuning, decay and other sonic characteristics.

## Schematic

![schematic](documentation/image/RP2040-VCO-schematic.svg)


## BoM

[See bom globale](http://computerei.hfbk.net/sdiy/rp2040/bom/RP2040-VCO-ibom-global.html)

[See bom board jack](http://computerei.hfbk.net/sdiy/rp2040/bom/RP2040-VCO-ibom-jack.html)

[See bom board circuit](http://computerei.hfbk.net/sdiy/rp2040/bom/RP2040-VCO-ibom-circuit.html)

## Building

:warning: When building modules, always do it in this order (from smallest component to highest):
- diodes (watch for the orientation!)
- resistors
- DIP chips (watch for the orientation!)
- capacitors (film/ceramic)
- Electrolytic capacitors (watch for the orientation!)

For the next part, place them *without soldering them*: 
- jacks, pots, buttons and switches that go throught the front panel

Once placed, put in place the front panel, then fasten all components to it. Once this is done, you can solder them. 

[Build guide]()

## Software upload

Uploading new Software isn't complicated, but a few things need to be in place for it to work

### 1. Install the Arduino IDE and the Seeed Xiao Board Manager

1. Download and install the [Arduino IDE](https://www.arduino.cc/en/software) for your operating system
2. Start the Arduino IDE and go to `File > Preferences`
   1. Copy this URL: `https://files.seeedstudio.com/arduino/package_seeeduino_boards_index.json` and paste it into the text input field at *Additional board manager URLs*. If there is already text there, go to the very end of the text, type a `,` there (if there isn't one already) and paste the URL there
   2. Finish the installation of the Seeed Xiao packages

### 2. Download this Project (which includes the code)

1. Click on the Download icon and `zip` on the top right of this repository site: ![image-20230703170233550](images/gitlab.png)
2. Unpack the folder stored in the zip file to some location and open it in your file manager
3. Go into the sub-directory called `Soft` and chose which software you want to upload. Doubleclick the file ending in `.ino` to open it in the Arduino IDE

### 3. Upload the code

1. Connect your Seeed Xiao via USB-C Cable to the computer that runs the Arduino IDE
2. Ensure the Arduino IDE sees the board by clicking on `Select other board or port...` in the bar on top:
    ![image-20230703170818004](images/select_board.png)
3. Search for `Seeed` and select the `Seeed XIAO RP2040` board if it hasn't been selected already (if it doesn't show up you need to install the board manager, see above). Then select the port and click okay. If no port shows up (see picture) check your cable/connection:
   ![image-20230703171243588](images/board_selection.png)
4. Click on the upload button: 
    ![image-20230703171418658](/home/d0/modular/_fremd/rp2040-chord-vco/images/upload.png)
5. After a moment the uploading should either be finished or a red error message should explain that something went wrong. If it worked you can unplug the Seeed Xiao now, if it errored you need to resolve the error.


## Images

![3D (front)](documentation/image/RP2040-VCO-3D_top.png)

![3D (back)](documentation/image/RP2040-VCO-3D_bottom.png)

![3D (iso)](documentation/image/RP2040-VCO-3D_top30deg.png)

