#define SAMPLES 1048




class Snare {
  public:
    float frequency;
    float base_frequency;
    float frequency_range;
    EnvelopeSimpleLog volume_envelope;
    EnvelopeSimpleLog pitch_envelope;
    EnvelopeSigh pitch_envelope_sigh;
    LPF lpf;
    HPF hpf;
    void setup();
    void update();
    void reset();
    void trigger();
    float render();
    void advanceOscillator();
    void setVolumeDecay(float speed);
    void setPitchDecay(float speed);
    void setPitchAmount(float amount);
    void setFrequency(float frequency);
    void setLpfFrequency(float frequency);
    void setLpfResonance(float resonance);

  private:
    int sinetable[SAMPLES];
    int noisetable[SAMPLES];
    float osc_progress = 0.0;
};

void Snare::setup() {
  // Fill the sinetable with a sine-wave
  for (int i = 0; i < SAMPLES; i++) {
    this->sinetable[i] = (sin(2 * M_PI * i  / SAMPLES)) * 511;
  }

  // Fill the noise-table with noise
  for (int i = 0; i < SAMPLES; i++) {
    this->noisetable[i] = random(0, 1023);
  }

  // Set some parameters
  this->volume_envelope.amount = 1.0;
  this->hpf.setFrequency(200.0);
  this->volume_envelope.setSnap(0.0005);
  this->pitch_envelope.setSnap(0.0005);

}

void Snare::update() {
  this->volume_envelope.update();
  this->pitch_envelope.update();
  this->pitch_envelope_sigh.update();
}

void Snare::reset() {
  this->volume_envelope.reset();
  this->pitch_envelope.reset();
  this->pitch_envelope_sigh.reset();
  this->osc_progress = 0;
}

void Snare::trigger() {
  this->reset();
  this->pitch_envelope_sigh.trigger();
}

float Snare::render() {
  float orig_sample = this->volume_envelope.value * (this->sinetable[(int)this->osc_progress] + this->pitch_envelope.value * noisetable[(int)this->osc_progress]);
  // lpf.addFrequency(pitch_envelope.value*500.0);
  float filtered_sample = hpf.render(lpf.render(orig_sample));
  float sample = orig_sample/2 + filtered_sample/2;
  return sample / 2 + 511;
}

void Snare::advanceOscillator() {
  this->osc_progress += this->frequency + this->pitch_envelope.value + this->pitch_envelope_sigh.value;
  if (this->osc_progress > SAMPLES) {
    this->osc_progress = 0;
  }
}

void Snare::setVolumeDecay(float speed) {
  this->volume_envelope.setSpeed(speed);
}

void Snare::setPitchDecay(float speed) {
  this->pitch_envelope.setSpeed(speed);
}

void Snare::setPitchAmount(float amount) {
  this->pitch_envelope.setAmount(amount);
}

void Snare::setFrequency(float frequency) {
  this->frequency = this->base_frequency + frequency * this->frequency_range;
}

void Snare::setLpfFrequency(float frequency) {
  this->lpf.setFrequency(frequency);
}

void Snare::setLpfResonance(float resonance) {
  this->lpf.setResonance(resonance);
}