#ifndef Leds_h
#define Leds_h
#include "Arduino.h"
#include "luts.h"


// Lookup Curves LED Red b
float red_lut_x[] = {170.0, 173.5, 177.0, 180.5, 184.0, 187.5, 191.0, 194.5, 198.0, 201.5, 205.0, 208.5, 212.0, 215.5, 219.0, 222.5, 240.0, 240.75, 241.5, 242.25, 243.0, 243.75, 244.5, 245.25, 246.0, 246.75, 247.5, 248.25, 249.0, 249.75, 250.5, 251.25, 255};
float red_lut_y[] = {0.0, 0.0037500000000000007, 0.030000000000000006, 0.10125000000000003, 0.24000000000000005, 0.46875, 0.8100000000000003, 1.2862500000000003, 1.9200000000000004, 2.7337500000000006, 3.75, 4.991250000000002, 6.480000000000002, 8.238750000000001, 10.290000000000003, 12.65625, 30.0, 31.1503125, 32.4525, 34.0584375, 36.12, 38.7890625, 42.2175, 46.5571875, 51.96, 58.5778125, 66.5625, 76.06593750000002, 87.24000000000001, 100.23656250000002, 115.20750000000002, 132.3046875, 255};
size_t red_lut_len = 33;

// Lookup Curves LED Green b
float green_lut_x[] = {10.0, 18.5, 27.0, 35.5, 44.0, 52.5, 61.00000000000001, 69.5, 78.0, 86.5, 95.0, 103.50000000000001, 112.00000000000001, 120.5, 129.0, 137.5, 180.0, 183.5, 187.0, 190.5, 194.0, 197.5, 201.0, 204.5, 208.0, 211.5, 215.0, 218.5, 222.0, 225.5, 229.0, 232.5, 250};
float green_lut_y[] = {0.0, 0.0075000000000000015, 0.06000000000000001, 0.20250000000000007, 0.4800000000000001, 0.9375, 1.6200000000000006, 2.5725000000000007, 3.8400000000000007, 5.467500000000001, 7.5, 9.982500000000003, 12.960000000000004, 16.477500000000003, 20.580000000000005, 25.3125, 60.0, 56.43, 52.92, 49.47, 46.08, 42.75, 39.48, 36.269999999999996, 33.120000000000005, 30.029999999999998, 27.000000000000007, 24.03, 21.119999999999997, 18.269999999999996, 15.480000000000004, 12.750000000000007, 0};
size_t green_lut_len = 33;

// Lookup Curves LED Blue b
float blue_lut_x[] = {0.0, 2.0, 4.0, 6.000000000000001, 8.0, 10.0, 12.000000000000002, 14.000000000000002, 16.0, 18.0, 20.0, 22.0, 24.000000000000004, 26.0, 28.000000000000004, 30.0, 40.0, 46.5, 53.0, 59.5, 66.0, 72.5, 79.0, 85.5, 92.0, 98.5, 105.0, 111.5, 118.00000000000001, 124.5, 131.0, 137.5, 170.0, 170.0, 170.0, 170.0, 170.0, 170.0, 170.0, 170.0, 170.0, 170.0, 170.0, 170.0, 170.0, 170.0, 170.0, 170.0};
float blue_lut_y[] = {0.0, 0.10099999999999998, 0.20799999999999996, 0.327, 0.46399999999999997, 0.6249999999999999, 0.8160000000000001, 1.0430000000000001, 1.312, 1.629, 1.9999999999999998, 2.4310000000000005, 2.928000000000001, 3.497, 4.144000000000001, 4.875, 10.0, 9.025, 8.1, 7.225, 6.4, 5.625, 4.9, 4.225, 3.5999999999999996, 3.0250000000000004, 2.5, 2.0249999999999986, 1.5999999999999996, 1.2250000000000014, 0.9000000000000004, 0.625, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
size_t blue_lut_len = 48;





class RGBLed {
  int pin_red;
  int pin_green;
  int pin_blue;
  float level = 0.0f;
  Easer easer;

  public:
    RGBLed(int pin_red, int pin_green, int pin_blue);
    void init();
    void off();
    void setColor(int r, int g, int b);
    void setAudioLevelIndicator(float envelope_value);
};

RGBLed::RGBLed(int pin_red, int pin_green, int pin_blue) {
  this->pin_red = pin_red;
  this->pin_green = pin_green;
  this->pin_blue = pin_blue;
  this->easer.setFactor(0.7);
}

void RGBLed::init() {
  pinMode(this->pin_red, OUTPUT);
  pinMode(this->pin_green, OUTPUT);
  pinMode(this->pin_blue, OUTPUT);
}

void RGBLed::off() {
  digitalWrite(this->pin_red, LOW);
  digitalWrite(this->pin_green, LOW);
  digitalWrite(this->pin_blue, LOW);
}

void RGBLed::setColor(int r, int g, int b) {
  r = min(255, max(0, r));
  g = min(255, max(0, g));
  b = min(255, max(0, b));
  analogWrite(this->pin_red, r);
  analogWrite(this->pin_green, g);
  analogWrite(this->pin_blue, b);
}

void RGBLed::setAudioLevelIndicator(float envelope_value) {
  level = easer.Process(envelope_value);
  int brightness = int(min(255.0f, max(0.0f, level * 255)));
  int red = get_from_xy_table(red_lut_x, red_lut_y, brightness, red_lut_len);
  int green = get_from_xy_table(green_lut_x, green_lut_y, brightness, green_lut_len);
  int blue = get_from_xy_table(blue_lut_x, blue_lut_y, brightness, blue_lut_len);
  this->setColor(red, green, blue);
}

#endif