---
software: daisyy-looper
hardware: daisyy-hardware
language: C++
---

# daisyy-looper

![Photograph of the OLED-Screen on the daisyy](images/screen.jpg){width=35em}

*daisy-looper* is a software that can be installed on the [daisyy hardware](https://code.hfbk.net/sdiy/daisyy/daisyy-hardware) developed in the course *Synthesizer DIY* that took place during winter semester 2023/2024 at HFBK Hamburg.

## Overview

The looper allows you to record audio from the input and [overdub](https://en.wikipedia.org/wiki/Overdubbing) onto up to 5 different virtual "tapes" called *buffers*. The recorded sounds stored in each buffer will be displayed as a waveform and can be played back at different speeds (including reverse speed) or no speed at all.

Just like with real tape the pitch of the played back sounds changes when the speed of the playhead changes. This can be used for interesting effects.



## Interface

![Mockup of the Daisy Looper Interface](images/interface.svg){width=35em}  



| Element        | Description                                                  |
| -------------- | ------------------------------------------------------------ |
| Loop Start     | Changes where the loop start position is within the current buffer |
| Loop Length    | Changes the length of the loop                               |
| Mix            | Mixes between incoming audio and the output of the looper<br>All the way to the left only the incoming (»dry«) audio is heard<br>All the way to the right only the looped (»wet«) audio is heard |
| Speed          | Changes the speed of the playhead<br>With a centered knob the speed is 0% |
| Input Gain     | Adjusts the level of the incoming audio before it gets converted to digital<br>The RGB-LED displays the incoming audio levels (red means it is clipping) |
| Loop Volume*   | Adjusts the volume of the Loopers output                     |
| Reverb Amount* | Mixes in a Reverb that affects both the incoming and the looped signal |
| LFO Amount*    | Adjusts the Amount with which the LFO will affect the position of the playhead, this can lead to very mangled and experimental sounds |
| Rec Menu       | Pressing and holding this button opens up the `REC MENU` where settings for the way things are recorded can be changed |
| Play Menu      | Pressing and holding this button opens up the `PLAY MENU` where settings affecting the Playback can be changed |
| FX Menu        | Pressing and holding this button opens up the `FX MENU` where certain aspects of the effects can be changed more in depth (e.g. Reverb Decay time, LFO-Waveform or Speed, etc.) |
| REC Button     | Pressing this button records audio, overwriting/erasing sounds that are already there |
| OVR Button     | Pressing this button overdubs audio, adding to sounds that are already there |
| Buffer Menu    | Pressing and holding this button will let you change the currently active buffer, giving you a new, clean slate to record into |

*Depending on the settings in the `FX MENU` this knob can have different functions

## Menus

### Play Menu

![Illustration of the Options in the Play Menu](images/menu-play.jpg)  

| What      | Options                           | Description                                                  |
| --------- | --------------------------------- | ------------------------------------------------------------ |
| Play Mode | Stop / <u>Loop</u> / Multi / MIDI | How the looper plays back audio:<br><b>Stop:</b> Don't play at all<br><b><u>Loop:</u></b> Play a loop with a single playhead (default)<br><b>Multi:</b> Play a loop with multiple playheads<br><b>MIDI:</b> Play only on incoming MIDI notes |
| Mix Mode  | <u>Active</u> / Sum / Ring        | How the 5 available Buffers are mixed with each other<br><b><u>Active:</u></b> Only the currently active/visible buffer is heard (default)<br><b>Sum:</b> All buffers are heard, even if they are not visible<br><b>Ring:</b> All buffers are ring-modulated with the incoming audio (meaning only if *both* the input and our loop produce sounds we hear something) |
| Restart   | -                                 | Press to jump the playhead back to the start of the loop     |
| Slow Down | -                                 | Press and hold to start a vinyl-style slowdown               |
| Reverse   | -                                 | Press and hold to reverse the playback                       |



