# Build Environment Setup

This project uses `arduino-cli` to allow us to build binaries for the daisy seed using a build script.

## Prerequesites

- Install the usual Daisy-Seed build environment
- install `arduino-cli`
- hope that was all

## Installing the Dependencies

arduino-cli is a totally separate tool from the Arduino GUI application, that means it manages boards and libraries separately. In order to get this project started follow the steps below:


### 1. Install h7 board

```bash
arduino-cli core install --additional-urls https://github.com/stm32duino/BoardManagerFiles/raw/main/package_stmicroelectronics_index.json STMicroelectronics:stm32
```

### 2. Install library dependencies

```bash
arduino-cli lib install 'DaisyDuino'
arduino-cli lib install 'Adafruit GFX Library'
arduino-cli lib install 'Adafruit SH110X'
arduino-cli lib install 'MIDI Library'
arduino-cli lib install 'MultiMap'
```


## Building

At this point you should be able to run `./build.sh` which should create new bin files in your build directory.

### More Details

Get board details and the Fully Qualified Board Name (fqbn) using this command:

```bash
arduino-cli board search --additional-urls https://github.com/stm32duino/BoardManagerFiles/raw/main/package_stmicroelectronics_index.json H7
```

You can list all build options using:

```bash
arduino-cli board details --fqbn STMicroelectronics:stm32:GenH7
```

These options can be attached to the FQBN used in the build.sh, e.g. like this:
```bash
--fqbn 'STMicroelectronics:stm32:GenH7:pnum=DAISY_SEED,xserial=generic,usb=none,xusb=FS,opt=osstd,dbg=none,rtlib=nano,upload_method=dfuMethod'
```

## defines

Within the build script we also have a `--build-property build.extra_flags=-DSOME_DEFINED_FLAG` which allows us to pass preprocessor definitions to our arduino files, e.g. in our case we pass `BOARD_VERSION_1_1` which allows us to react to pinout changes in different board versions by using preprocessor-if else structures