---
software: daisyy-looper
hardware: daisyy-hardware
language: C++ (Arduino)
version: 1.2.0
---

# daisyy-looper

![Photograph of the OLED-Screen on the daisyy](images/screen.jpg){width=35em}

*daisy-looper* is a software that can be installed on the [daisyy hardware](https://code.hfbk.net/sdiy/daisyy/daisyy-hardware) developed in the course *Synthesizer DIY* that took place during winter semester 2023/2024 at HFBK Hamburg.

## Overview

The looper allows you to record audio from the input and [overdub](https://en.wikipedia.org/wiki/Overdubbing) onto up to 5 different virtual "tapes" called *buffers*. The recorded sounds stored in each buffer will be displayed as a waveform and can be played back at different speeds (including reverse speed) or no speed at all.

Just like with real tape the pitch of the played back sounds changes when the speed of the playhead changes. This can be used for interesting effects.

For installation instructions [see below](#Installation).

  



## Interface

![Mockup of the Daisy Looper Interface](images/interface.svg)   



| Element        | Description                                                  |
| -------------- | ------------------------------------------------------------ |
| Loop Start     | Changes where the loop start position is within the current buffer |
| Loop Length    | Changes the length of the loop                               |
| Mix            | Mixes between incoming audio and the output of the looper<br>All the way to the left only the incoming (»dry«) audio is heard<br>All the way to the right only the looped (»wet«) audio is heard |
| Speed          | Changes the speed of the playhead<br>With a centered knob the speed is 0% |
| Input Gain     | Adjusts the level of the incoming audio before it gets converted to digital<br>The RGB-LED displays the incoming audio levels (red means it is clipping) |
| Loop Volume*   | Adjusts the volume of the Loopers output                     |
| Reverb Amount* | Mixes in a Reverb that affects both the incoming and the looped signal |
| LFO Amount*    | Adjusts the Amount with which the LFO will affect the position of the playhead, this can lead to very mangled and experimental sounds |
| Rec Menu       | Pressing and holding this button opens up the `REC MENU` where settings for the way things are recorded can be changed |
| Play Menu      | Pressing and holding this button opens up the `PLAY MENU` where settings affecting the Playback can be changed |
| FX Menu        | Pressing and holding this button opens up the `FX MENU` where certain aspects of the effects can be changed more in depth (e.g. Reverb Decay time, LFO-Waveform or Speed, etc.) |
| REC Button     | Pressing this button records audio, overwriting/erasing sounds that are already there |
| OVR Button     | Pressing this button overdubs audio, adding to sounds that are already there |
| Buffer Menu    | Pressing and holding this button will let you change the currently active buffer, giving you a new, clean slate to record into |

*Depending on the settings in the `FX MENU` this knob can have different functions  



## Menus

### Rec Menu

![Illustration of the Options in the Recording Menu](images/menu-rec.jpg)  

| What                     | Options                             | Description                                                  |
| ------------------------ | ----------------------------------- | ------------------------------------------------------------ |
| Button-Mode              | <u>Momentary</u> / Toggle           | Whether the REC and OVERDUB buttons act as momentary or toggle:<br><b><u>Momentary:</u></b> Record only while button is being held (default)<br><b>Toggle:</b> Press once to record, press again to stop recording<br> |
| Recording Source         | <u>In</u> / Last / Out / Noise      | Selects the source that is being recorded<br><b><u>In:</u></b> The signal at the inputs (default)<br><b>Last:</b> The signal from the buffer that has been active before this one<br><b>Out:</b> The signal present at the output (may introduce feedback)<br><b>Noise:</b> A internal noise source |
| Recording Mode           | Full / <u>Loop</u> / Shot           | Selects the recording area and mode<br/><b>Full:</b> Record into the whole buffer, looping over at the end<br/><b><u>Loop:</u></b> Record only into the loop area, looping over at the end (default)<br/><b>Shot:</b> Record into the full buffer and stop at the end |
| Pitch Mode               | <u>Normal</u> / Unpitched           | Change how pitch is treated during recording:<br><b><u>Normal:</u></b> Record at the same speed regardless of the current playhead speed (default)<br><b>Unpitched:</b> Record at the same speed as the speed of the playhead |
| Recording Start Position | Start / <u>Loopstart</u> / Playhead | Change where the recording should start from:<br/><b>Start:</b> Start of the buffer<br/><b><u>Loopstart:</u></b> Start of the loop (default)<br/><b>Playhead:</b> Current position of the playhead |

  

### Play Menu

![Illustration of the Options in the Play Menu](images/menu-play.jpg)  

| What      | Options                           | Description                                                  |
| --------- | --------------------------------- | ------------------------------------------------------------ |
| Play Mode | Stop / <u>Loop</u> / Grain / MIDI | How the looper plays back audio:<br><b>Stop:</b> Don't play at all<br><b><u>Loop:</u></b> Play a loop with a single playhead (default)<br><b>Grain:</b> Play a loop with multiple playheads<br><b>MIDI:</b> Play only on incoming MIDI notes |
| Mix Mode  | <u>Active</u> / Sum / Ring        | How the 5 available Buffers are mixed with each other<br><b><u>Active:</u></b> Only the currently active/visible buffer is heard (default)<br><b>Sum:</b> All buffers are heard, even if they are not visible<br><b>Ring:</b> All buffers are ring-modulated with the incoming audio (meaning only if *both* the input and our loop produce sounds we hear something) |
| Restart   | -                                 | Press to jump the playhead back to the start of the loop     |
| Slow Down | -                                 | Press and hold to start a vinyl-style slowdown               |
| Reverse   | -                                 | Press and hold to reverse the playback                       |



  

### FX Menu

![Illustration of the Options in the FX Menu](images/menu-fx.jpg)  

| What       | Options   | Description                                                  |
| ---------- | --------- | ------------------------------------------------------------ |
| <u>ALL</u> | (default) | This Option is the default. The three right-bottom knobs have the following functions:<br/><b>Volume:</b> Controls the volume of the Loop<br/><b>Reverb:</b> Controls the amount of Reverb added to the signal<br/><b>LFO:</b> Controls the amount with which the LFO modulates the position of the playhead |
| REVERB     | -         | With this option selected, the three right-bottom knobs have the following functions:<br/><b>Reverb Decay:</b> How long the Reverb decays out<br/><b>Reverb Mix:</b> How much of the Reverb is heard<br/><b>Reverb Tone:</b> How dull or bright the Reverb sounds |
| LFO        | -         | With this option selected, the three right-bottom knobs have the following functions:<br/><b>LFO Speed:</b> How fast the modulation happens<br/><b>LFO Amount:</b> By how much should the LFO modulate the Playhead<br/><b>LFO Kind:</b> Which LFO-style to use (`Triangle`, `Square`, `Random`, `Jump`) |
| GRAIN      | -         | With this option selected, the three right-bottom knobs have the following functions (this switches the Playback Mode to GRAIN, to go back change this option in the Play Menu):<br/><b>Grain Spread:</b> How far apart the multiple playheads should be spread out in terms of speed difference<br/><b>Grain Variation:</b> How much variation to add to the speed of individual playheads<br/><b>Grain Count:</b> How many playheads to use |
| -          | -         | currently unused                                             |



### Buffer Menu

![Illustration of the Options in the Buffer Menu](images/menu-buffer.jpg)  

| What     | Options   | Description                                                  |
| -------- | --------- | ------------------------------------------------------------ |
| <u>A</u> | (default) | This Option is the default. Select the Buffer A for playback and recording |
| B        | -         | Select the Buffer B for playback and recording               |
| C        | -         | Select the Buffer C for playback and recording               |
| D        | -         | Select the Buffer D for playback and recording               |
| E        | -         | Select the Buffer E for playback and recording               |



## Installation



### Option 1: Daisy Web Programmer

The fastest way to install this software on your daisyy is to use the Daisy Web Programmer, as this does not require you to install anything on your computer:

1. Download the latest `daisyy-looper.bin` in [this projects *Releases* page](https://code.hfbk.net/sdiy/daisyy/daisyy-software/daisyy-looper/-/releases/permalink/latest)
2. Connect your daisyy to your computer using a USB-micro B cable (make sure to use a cable that has a data connection)
3. Put your daisy-seed into the `DFU-mode` to prepare it for uploading:
   1. Press and *hold* the `BOOT` button on the back of the daisy-seed board (take of the bottom of the case to get there)
   2. Press and *release* the `RESET` button right next to the other button
   3. Now *release* the `BOOT` button you pressed two steps before
   4. If everything went right and your RGB-LED has been soldered correctly that RGB-LED should now light up in a bright green, indicating that the daisy seed is ready for uploading
4. Open the [Daisy Web Programmer](https://electro-smith.github.io/Programmer/) in a Web-MIDI-capable Browser (as of 2024-02-16 only Chromium/Google Chrome seems to work)
5. Click on the yellow <kbd>Connect</kbd> button to connect to the daisy seed. If this does not work check if you are really in DFU-Mode (see steps above)
6. Select `DFU in FS Mode - Paired` from the list. If it says something with "Daisy" or the DFU-thing is not in the list, check your cable or try again with Step 3.
6. Click on the <kbd>Choose File</kbd> button and select the `daisyy-looper.bin` file you downloaded in Step 1
7. Click on the <kbd>Program</kbd> button on the bottom to upload the code
8. If everything worked right there should be a text saying (among other things) *Done!* – your daisyy should restart and the looper should now run



### Option 2: Arduino

#### Arduino IDE Setup

If you like you can follow [Electrosmith's Video Instructions](https://www.youtube.com/watch?v=UyQWK8JFTps) on how to setup the ardino IDE to work with daisy. The short list version is:

1. Install Arduino IDE from [arduino.cc](https://www.arduino.cc/en/software)
2. Follow the instructions at [sm32duino](https://github.com/stm32duino/Arduino_Core_STM32/wiki/Getting-Started):
	1. In Arduino under `Preferences > Additional Board Manager URLs` add the following text:
	`https://github.com/stm32duino/BoardManagerFiles/raw/main/package_stmicroelectronics_index.json`
	(Note: If you already have other URLs there, you need to seperate them with a comma)
	2. Open the `Board Manager` in Arduino (one of the icons on the left) and install the board `STM32 MCU based boards` by STMicroelectronics
	3. Follow the extra step, download and install the STM32CubeProgrammer Software from [here](https://www.st.com/en/development-tools/stm32cubeprog.html)
	<u>Mac:</u> You will have to use the workaround described [in the video](https://youtu.be/UyQWK8JFTps?t=164)
	<u>Linux:</u> Make sure the stm32cube binaries can be found in the PATH by the Arduino IDE

#### Install DaisyDuino Library

1. Click on the `Library Manager` icon in the left bar
2. Search for `DaisyDuino`
3. Click <kbd>INSTALL</kbd>

#### Arduino IDE Settings

**NOTE:** It can happen that these settings get lost if you update the STM32 board files

Change the following settings in the `Tool` menu on the top:

| Name                     | Setting                                    |
| ------------------------ | ------------------------------------------ |
| Board                    | `Generic STM32H7 Series`                   |
| Board part number        | `Daisy Seed`                               |
| USB support              | `CDC (generic 'Serial' supersede U(S)ART)` |
| U(S)ART support          | `Enabled (Generic 'Serial')`               |
| USB speed (if available) | `Low/Full Speed`                           |
| Upload method            | `STM32CubeProgrammer (DFU)`                |

#### Uploading the Code

1. Download the Code on this page by clicking on the <kbd>Code</kbd> button on top and selecting `.zip`
2. Unpack the zip file somewhere on your computer
3. Connect your Daisy Seed to your computer via USB. The red power LED should now glow
4. Set the daisy to DFU/Programming mode by pressing the buttons in the following order:
  1. Press and HOLD the `BOOT` button
  2. Click the `RESET` button`
  3. Release the `BOOT` button
5. Open the `daisyy-looper.ino` file in the unzipped project folder using the Arduino-IDE
6. Ensure on top next to the round buttons the board `Generic STM32H7 Series` is shown (if not follow the steps outlined above in the section *Arduino IDE Settings*)
7. Click on the round Upload button (an arrow pointing to the right)
8. After uploading the daisyy should restart and the looper should now work – any errors during the upload should be displayed
