# Build Instructions



## Glossary

What is...

<table>
    <tr>
        <td><i>PCB</i></td> <td>A <u>P</u>rinted <u>C</u>ircuit <u>B</u>oard. Electrical components (parts) can be soldered onto them</td>
	</tr>
	<tr>
        <td><i>Pins</i></td> <td>The "legs" of a part. Meant to be put onto a <u>Pad</u> or into a <u>through hole</u></u></u></td>
	</tr>
	<tr>
        <td><i>Pad</i></td> <td>A small metallic "landing zone" on the PCV. Parts can be soldered there</td>
	</tr>
    <tr>
        <td><i>Through Hole</i></td> <td>Short: <i>TH</i> – a metallic plated hole that goes through the PCB. The pins of parts can be connected through here</td>
	</tr>
    <tr>
        <td><i>SMD</i></td> <td>A <u>S</u>urface <u>M</u>ount <u>D</u>evice. A part that is soldered onto Pads instead of using <u>through hole</u> technology. SMD-parts are typically smaller and cheaper than their TH-equivalents</td>
	</tr>
    <tr>
        <td><i>Trace</i></td> <td>Traces are copper connections on the PCB</td>
	</tr>
    <tr>
        <td><i>Silkscreen</i></td> <td>A (typically white) print on the PCB that indicates where which part goes</td>
	</tr>
    <tr>
        <td><i>Reference Designator</i></td> <td>Every part on a PCB has it's very own, unique reference designator. The prefix of this short text tells us what kind of part it is. E.g. <code>R1</code> would be "Resistor 1" etc.</td>
	</tr>
    <tr>
        <td><i>Orientation</i></td> <td>Certain parts must be placed in the right orientation (rotation). That means you can easily solder them in the wrong way. Typically both the part and the </td>
	</tr>
</table>




<p class="alert alert-info">⚠️  The silkscreen of the RGB-LED is on the <u>wrong</u> side of the PCB! Solder it on the other side! Check instructions below!</p>

## Before soldering

- ⚠️ the order in which parts are soldered is important. If in doubt follow the order below
- the part of the PCB labeled `MIC PREAMP` and bordered off with a thick white line can be ignored and must not be soldered
- Anything that has more than two pins: solder <u>one</u> outside/corner pin first. Then adjust the position by reheating this fresh solder joint till you are happy with the orientation (typically parts should be flush with the PCB and straight on their "landing pads"). Only when you are happy with the orientation you solder the rest of the pins!
- Desoldering is way, *way* more work than soldering
- The hardest part is going to be the RGB-LED, because there is not much space. Take your time. Slow is fast.

## Soldering order

- [ ] Read the instructions above
- [ ] ⚡ Discharge yourself by touching the PE pins of an electrical outlet to avoid electrostatic charges destroying pins. 
- [ ] Solder `U1`: This is a SMD IC with 8 pins
  - [ ] Add solder to one of the 4 corner-pads first
  - [ ] ⚠️ Make sure you get the orientation of the part right. There is a small circle on the PCB indicating Pin 1
- [ ] Solder all resistors except `R4` (the upright one)
- [ ] Solder the socket for `U3`
- [ ] Solder `D1` (⚠️ orientation) and `C3`
- [ ] Solder `C1` (⚠️ orientation) and `C2` (⚠️ orientation)
- [ ] Connect the solder bridge on the other side of the PCB where it says `Bridge with soder`. This connects digital and analog ground together.
  electrostatic charges destroying pins. 
- [ ] Soldering the Daisy Seed:
  - [ ] ⚡ Discharge yourself by touching the PE pins of an electrical outlet to avoid 
  - [ ] Put the long pinheaders onto the pins of the `Daisy` and place the resulting thing into the pins where it says `U2 DAISY SEED`. 
  - [ ] ⚠️ Make sure the Daisy Seed's USB connector is pointing in the right direction (see silkscreen)
  - [ ] Solder one corner pin first, reheat if necessary to make things straight/flush
  - [ ] Solder the rest of the 41 pins ; )
  - [ ] When you are done: Carefully remove the Daisy again and place it back into its bag
- [ ] Soldering the Cherry MX switches
  - [ ] Put the keycaps (blue) onto the Cherry MX switches
  - [ ] Place them into the dark side of the board
  - [ ] Tape the switches in place so they don't fall out when you turn the board over, then turn the board over
  - [ ] ⚠️ These switches are hard to solder in straight! 
  	- [ ] Solder only one pin per switch first so they won't fall out
  	- [ ] Remove the tape
  	- [ ] Reheat the solder joints to carefully move the switches so the keycaps look like a nice grid
  	- [ ] Do this till you are happy with the position
  	- [ ] Now solder the other pins of the switches
- [ ] Solder the potentiometers
  - [ ] ⚠️ It is easy to solder them in weirdly. Solder only the central pin first and re-align the part by reheating that pin and pushing the part with your finger at the same time. The goal is to make all four bottom metallic parts touch the PCB. See red circles:
  <img src="images/solder-pot.jpg">
  - [ ] Once you feel like the potentiometer doesn't look like the leaning tower of Pisa, solder the rest of its connections (make sure the part keeps its position, when you do this – reheating all the pins at once is not possible)
- [ ] Solder the big black connection jacks 
  - [ ] ⚠️ the inlet is pointing to the right direction (edge of the PCB)
  - [ ] ⚠️ Make sure they are flush with the PCB, otherwise they won't fit with the holes in the case
  - [ ] ⚠️ Some of the pins are now <u>underneath</u> the potentiometers. This is harder to solder, but not impossible. Avoid burning other parts by *thinking* about the direction from which you move in with the soldering iron.
- [ ] Solder the OLED Display
  - [ ] Screw the plastic standoffs into the two holes of the Display (on the side without pins)
  - [ ] Place the panel onto the PCB and screw the standoffs in from the other side
  - [ ] Solder one pin of the panel and make sure it is aligned and level (re-heat and move if it is not)
  - [ ] Solder the rest of the pins
- [ ] Solder the RGB-LED `D2` – Read below before proceeding: 
  - [ ] ⚠️⚠️⚠️ The silkscreen is on the WRONG side of the PCB! The part should be on the side without)
  - [ ] ⚠️⚠️ There is no space for soldering *and* cutting the pins on the other side. This part has to be soldered from the top.
  - [ ] ⚠️ orientation: one of the through holes has a square pad. This is where the longest pin of the LED should go. Shorten the other pins before putting in (if in doubt: ask)
  - [ ] The LED is <u>not</u> meant to be soldered flush with the PCB. It should stick out of the panel. Check David's board for reference
  - [ ] The 4 pins are <u>not</u> allowed to connect to each other with solder bridges. If there is too much solder, remove it using solder wick.
- [ ] Put everything into the case
- [ ] Solder two wires to the DIN-MIDI-connector (look at the schematic for a connection diagram) and place the midi socket in and solder the cables to the board (⚠️ it matters which is soldered where!)
- [ ] Before connecting it to any USB-source, visually inspect the board for any obvious problems, solder bridges, missing pins etc.



## Now that the hardware is done

Upload a software. Instructions TBD

