#ifndef LUTs_h
#define LUTs_h

#include "MultiMap.h"

// Lookup Table for Bipolar Curve with deadband
float bip_lookup[] = {0.0, 0.08060869565217388, 0.1597391304347826, 0.23886956521739133, 0.318, 0.3971304347826087, 0.47626086956521746, 0.5, 0.5, 0.5237391304347826, 0.6028695652173913, 0.6819999999999999, 0.7611304347826088, 0.8402608695652175, 0.9193913043478261, 1.0};
size_t bip_lookup_length = 16;

// Lookup Table for Pitch Knob
float pitch_knob_lookup_x[] = {0.0, 0.0025, 0.0175, 0.0225, 0.0375, 0.0425, 0.057499999999999996, 0.0625, 0.0775, 0.0825, 0.0975, 0.10250000000000001, 0.1175, 0.1225, 0.1375, 0.14250000000000002, 0.1575, 0.1625, 0.1975, 0.2025, 0.2475, 0.2525, 0.2975, 0.3025, 0.3775, 0.3825, 0.4175, 0.4225, 0.4575, 0.4625, 0.4975, 0.5025, 0.5375000000000001, 0.5425, 0.5775000000000001, 0.5825, 0.6175, 0.6224999999999999, 0.6975, 0.7024999999999999, 0.7475, 0.7525, 0.7975000000000001, 0.8025, 0.8375, 0.8424999999999999, 0.8575, 0.8624999999999999, 0.8775000000000001, 0.8825, 0.8975000000000001, 0.9025, 0.9175000000000001, 0.9225, 0.9375, 0.9424999999999999, 0.9575, 0.9624999999999999, 0.9775, 0.9824999999999999, 0.9975, 1.0};
float pitch_knob_lookup_y[] = {-1.0, -1.0, -0.9, -0.9, -0.8, -0.8, -0.7, -0.7, -0.6, -0.6, -0.5, -0.5, -0.4, -0.4, -0.3, -0.3, -0.2, -0.2, -0.1, -0.1, -0.05, -0.05, -0.025, -0.025, -0.0125, -0.0125, -0.00625, -0.00625, -0.003125, -0.003125, 0.0, 0.0, 0.003125, 0.003125, 0.00625, 0.00625, 0.0125, 0.0125, 0.025, 0.025, 0.05, 0.05, 0.1, 0.1, 0.2, 0.2, 0.3, 0.3, 0.4, 0.4, 0.5, 0.5, 0.6, 0.6, 0.7, 0.7, 0.8, 0.8, 0.9, 0.9, 1.0, 1.0};
size_t pitch_knob_lookup_length = 62;


// Lookup Curves for Saturation b
float saturation_lookup_x[] = {-1.5, -1.46, -1.42, -1.38, -1.3399999999999999, -1.3, -1.26, -1.22, -0.7, 0.0, 0.7, 0.74, 0.78, 0.82, 0.86, 0.8999999999999999, 0.94, 0.98, 1.5};
float saturation_lookup_y[] = {-0.5, -0.49998125, -0.49985, -0.49949375, -0.4988, -0.49765625, -0.49595, -0.49356875, -0.35, 0.0, 0.35, 0.367475, 0.38389999999999996, 0.399275, 0.41359999999999997, 0.426875, 0.4391, 0.450275, 0.5};
size_t saturation_lookup_length = 19;


class Easer {
  float output = 0.0f;
  float delta = 0.0f;
  float easing = 0.1f;
  public:
    Easer();
    
    float Process(float input) {
      delta = input - output;
      output += delta * easing;
      return output;
    }

    void setFactor(float factor) {
      easing = min(max(0.00001f, factor), 1.0f);
    }
};

Easer::Easer() {

};


float lerp(float a, float b, float f) {
  f = min(1.0f, max(0.0f, f));

  if (f == 0.0) { return a; }
  else if (f == 1.0f) { return b; }
  else { return a * (1.0f-f) + b * f; }
}

float get_from_table(float* table, float f, size_t length) {
  f = min(1.0f, max(0.0f, f));
  float pos = (length-1) * f;
  float pos_frac = fmod(pos, 1.0f);
  if (pos_frac == 0.0f) {
    return table[int(pos)];
  }
  float a = table[int(floor(pos))];
  float b = table[int(ceil(pos))];
  if (a == b) { return a; }
  return lerp(a, b, pos_frac);
}

float get_from_xy_table(float* xtable, float* ytable, float f, size_t length) {
  return multiMap<float>(f, xtable, ytable, length);
}

float saturate(float input) {
  return get_from_xy_table(
    saturation_lookup_x, 
    saturation_lookup_y, 
    min(1.5f, max(-1.5f, input)), 
    saturation_lookup_length
  );
}

#endif