 # Daisyy

A small synthesizer/effect/whatever utilizing the [Daisy Seed DSP Board by Electrosmith](https://www.electro-smith.com/daisy/daisy). This is essentially a high powered Arduino with two audio inputs and two audio outputs, inputs for up to 12 knobs or faders and a ton of memory.

This is how the unit could look like (artist rendering, blender files in the repo):

![](3d/renders/daisyy1.png)

## Planned Features

- 1.3" OLED Display (black and white) with 128×64 pixels

- 8 Knobs (7 can be used in code, 1 is for input volume)

- RGB-LED for display of input levels

- MIDI in

- Powered via USB

- <u>Optional:</u> Mic Preamp (without Phantom power, needs external 12V power supply)

  
  
Soldering instuctions [can be found here](solder_instructions.md)
  
  

## Software

The Daisy Seed is a microcontroller with audio capabilities. This means it can become many different things depending on the code uploaded. The Daisy Seed can be programmed using multiple toolchains[^1] – in the course we will hover mainly use the Arduino IDE which can be downloaded on [arduino.cc](https://www.arduino.cc/en/software). After setting up the toolchain (see [here](https://github.com/electro-smith/DaisyWiki/wiki/1a.-Getting-Started-(Arduino-Edition)) for instructions), the code can be uploaded using the Arduino IDE and a USB-cable.

[^1]: See Section *programmable in* on: [https://www.electro-smith.com/daisy/daisy](https://www.electro-smith.com/daisy/daisy)

### Arduino IDE Setup

If you like you can follow [Electrosmith's Video Instructions](https://www.youtube.com/watch?v=UyQWK8JFTps) on how to setup the ardino IDE to work with daisy. The short list version is:

1. Install Arduino IDE from [arduino.cc](https://www.arduino.cc/en/software)
2. Follow the instructions at [sm32duino](https://github.com/stm32duino/Arduino_Core_STM32/wiki/Getting-Started):
	1. In Arduino under `Preferences > Additional Board Manager URLs` add the following text:
	```https://github.com/stm32duino/BoardManagerFiles/raw/main/package_stmicroelectronics_index.json``
	(Note: If you already have other URLs there, you need to seperate them with a comma)
	2. Open the `Board Manager` in Arduino (one of the icons on the left) and install the board `STM32 MCU based boards` by STMicroelectronics
	3. Follow the extra step, download and install the STM32CubeProgrammer Software from [here](https://www.st.com/en/development-tools/stm32cubeprog.html)
	<u>Mac:</u> You will have to use the workaround described [in the video](https://youtu.be/UyQWK8JFTps?t=164)
	<u>Linux:</u> Make sure the stm32cube binaries can be found in the PATH by the Arduino IDE

### Install DaisyDuino Library

1. Click on the `Library Manager` icon in the left bar
2. Search for `DaisyDuino`
3. Click <kbd>INSTALL</kbd>

### Arduino IDE Settings

**NOTE:** It can happen that these settings get lost if you update the STM32 board files

Change the following settings in the `Tool` menu:

| Name | Setting |
| -------- | ----------|
| Board | `Generic STM32H7 Series` |
| Board part number | `Daisy Seed` |
| USB support | `CDC (generic 'Serial' supersede U(S)ART)` |
| U(S)ART support | `Enabled (Generic 'Serial')` |
| USB speed (if available) | `Low/Full Speed` |
| Upload method | `STM32CubeProgrammer (DFU)` |

### Testing the board

1. Connect your Daisy Seed to your computer via USB. The red power LED should now glow
2. Set the daisy to DFU/Programming mode by pressing the buttons in the following order:
	1. Press and HOLD the `BOOT` button
	2. Click the `RESET` button`
	3. Release the `BOOT` button
3. In Arduino open the Blink-Example in `File > Examples > 01.Basics > Blink`
4. Ensure on top next to the round buttons the board `Generic STM32H7 Series` is shown (if not follow the steps outlined above in the section *Arduino IDE Settings*)
5. Click on the round Upload button (an arrow pointing to the right)
6. After uploading the onboard LED of the Daisy Seed should blink (if not the Arduino IDE will show a red error in the area on bottom)

If this works you can now check other examples (or the DaisyDuino-Examples in `File > Examples > DaisyDuino`)



## Schematic

![](images/schematic-1.jpg)  
![](images/schematic-2.jpg)  
![](images/schematic-3.jpg)  