// Title: Envelope Follower
// Description: Drives an RGB-LED from an Envelope follower
// Hardware: Daisy Seed
// Author: David Huss

#include "DaisyDuino.h"
#include "env_follower.h"
#include "leds.h"

DaisyHardware hw;

// Create an instance of the envelope folower
atoav::EnvelopeFollower envelope_follower;


// LED                  R    G    B
RGBLed rgb_led = RGBLed(A10, A9, A11);

size_t num_channels;



void AudioCallback(float **in, float **out, size_t size) {
  for (size_t i = 0; i < size; i++) {
    // Generate the envelope (only use channel 2)
    envelope_follower.Process(in[1][i]);
    // Input goes directly to output
    for (size_t chn = 0; chn < num_channels; chn++) {
      out[chn][i] = in[chn][i];
    }
  }
}

void setup() {
  float samplerate;
  // Initialize for Daisy pod at 48kHz
  hw = DAISY.init(DAISY_SEED, AUDIO_SR_48K);

  // Initialize some variables 
  num_channels = hw.num_channels;
  samplerate = DAISY.get_samplerate();

  // Initialize the Envelope follower
  envelope_follower.Init(samplerate);
  envelope_follower.SetAttack(50.0);
  envelope_follower.SetDecay(200.0);

  

  DAISY.begin(AudioCallback);
  rgb_led.init();
  Serial.begin(250000);
}

void loop() {
  // Get the value from the envelope
  float envelope_reading = envelope_follower.getValue();
  
  // Set the brightness and Color of the LED depending on the envelope
  rgb_led.setAudioLevelIndicator(int(envelope_reading * 255));
}
