#ifndef LUTs_h
#define LUTs_h

#include "MultiMap.h"

// Lookup Table for Exponential Curve
float DSY_SDRAM_BSS exp_lookup[] = {0.0, 0.02040816326530612, 0.08163265306122448, 0.18367346938775508, 0.32653061224489793, 0.5102040816326531, 0.7346938775510203, 1.0};
size_t exp_lookup_length = 8;

// Lookup Table for Bipolar Curve with deadband
float DSY_SDRAM_BSS bip_lookup[] = {0.0, 0.08060869565217388, 0.1597391304347826, 0.23886956521739133, 0.318, 0.3971304347826087, 0.47626086956521746, 0.5, 0.5, 0.5237391304347826, 0.6028695652173913, 0.6819999999999999, 0.7611304347826088, 0.8402608695652175, 0.9193913043478261, 1.0};
size_t bip_lookup_length = 16;

// Lookup Table for Pitch Knob
float DSY_SDRAM_BSS pitch_knob_lookup_x[] = {0.0, 0.005, 0.04499999999999999, 0.054999999999999986, 0.09499999999999997, 0.10499999999999998, 0.14500000000000002, 0.15500000000000003, 0.195, 0.20500000000000002, 0.245, 0.255, 0.295, 0.305, 0.345, 0.355, 0.395, 0.405, 0.445, 0.455, 0.495, 0.505, 0.545, 0.555, 0.595, 0.605, 0.645, 0.655, 0.695, 0.705, 0.745, 0.755, 0.795, 0.805, 0.845, 0.855, 0.895, 0.905, 0.945, 0.955, 0.995, 1.005};
float DSY_SDRAM_BSS pitch_knob_lookup_y[] = {-1.0, -1.0, -0.9, -0.9, -0.8, -0.8, -0.7, -0.7, -0.6, -0.6, -0.5, -0.5, -0.4, -0.4, -0.3, -0.3, -0.2, -0.2, -0.1, -0.1, 0.0, 0.0, 0.1, 0.1, 0.2, 0.2, 0.3, 0.3, 0.4, 0.4, 0.5, 0.5, 0.6, 0.6, 0.7, 0.7, 0.8, 0.8, 0.9, 0.9, 1.0, 1.0};
size_t pitch_knob_lookup_length = 42;







float lerp(float a, float b, float f) {
  f = min(1.0f, max(0.0f, f));
  if (f == 0.0) { return a; }
  else if (f == 1.0f) { return b; }
  else { return a * (1.0f-f) + b * f; }
}

float get_from_table(float* table, float f, size_t length) {
  f = min(1.0f, max(0.0f, f));
  float pos = (length-1) * f;
  float pos_frac = fmod(pos, 1.0f);
  if (pos_frac == 0.0f) {
    return table[int(pos)];
  }
  float a = table[int(floor(pos))];
  float b = table[int(ceil(pos))];
  if (a == b) { return a; }
  return lerp(a, b, pos_frac);
}

float get_from_xy_table(float* xtable, float* ytable, float f, size_t length) {
  return multiMap<float>(f, xtable, ytable, length);
}

#endif