#ifndef Helpers_h
#define Helpers_h

#include "Adafruit_SH110X.h"
#include "Adafruit_GFX.h"
extern Adafruit_SH1106G display;

int centeredText(const char *buf, int x, int y, int color, int lineheight=8) {
  int16_t x1, y1;
  uint16_t w, h;
  char *line_pointer = strchr(buf, '\n');
  display.setTextColor(color);
  if (!line_pointer) {
    display.getTextBounds(buf, 0, 0, &x1, &y1, &w, &h); //calc width of new string
    display.setCursor(x - (w / 2), y - (h / 2));
    display.print(buf);
  }else {
    char *tmp = strdup(buf);
    char* d = strtok(tmp, "\n");
    int line = 0;
    while (d != NULL) {
        display.getTextBounds(d, 0, 0, &x1, &y1, &w, &h); //calc width of new string
        display.setCursor(x - (w / 2), y - (h / 2)-lineheight/2 + (line*lineheight));
        display.print(d);
        d = strtok(NULL, ",");
        line++;
    }
    free(tmp);
  }
  return w;
}

int centeredTextMark(const char *buf, int x, int y, int color, int underline_line=0, int lineheight=8) {
  int16_t x1, y1;
  uint16_t w, h;
  char *line_pointer = strchr(buf, '\n');
  display.setTextColor(color);
  if (!line_pointer) {
    display.getTextBounds(buf, 0, 0, &x1, &y1, &w, &h); //calc width of new string
    int x_start = x - (w / 2);
    int y_start = y - (h / 2);
    display.setCursor(x_start, y_start);
    if (underline_line == 1) {
        display.drawFastHLine(x_start-2, y_start+lineheight, w+4, color);
      }
    display.print(buf);
  }else {
    char *tmp = strdup(buf);
    char* d = strtok(tmp, "\n");
    int line = 0;
    while (d != NULL) {
        display.getTextBounds(d, 0, 0, &x1, &y1, &w, &h); //calc width of new string
        int x_start = x - (w / 2);
        int y_start = y - (h / 2)-lineheight/2 + (line*lineheight);
        display.setCursor(x_start, y_start);
        display.print(d);
        d = strtok(NULL, ",");
        if (underline_line == 1) {
          display.drawFastHLine(x_start-2, y_start+lineheight, w+4, color);
        }
        line++;
    }
    free(tmp);
  }
  return w;
}


int centeredTextMarkMulti(const char *buf, int x, int y, int color, int underline_line=0, int lineheight=8) {
  int16_t x1, y1;
  uint16_t w, h;
  char *line_pointer = strchr(buf, '\n');
  display.setTextColor(color);
  if (!line_pointer) {
    display.getTextBounds(buf, 0, 0, &x1, &y1, &w, &h); //calc width of new string
    int x_start = x - (w / 2);
    int y_start = y - (h / 2);
    display.setCursor(x_start, y_start);
    if (underline_line == 1) {
        display.drawFastHLine(x_start-2, y_start, w+4, color);
      }
    display.print(buf);
  }else {
    char *tmp = strdup(buf);
    char* d = strtok(tmp, "\n");
    int line = 0;
    while (d != NULL) {
        display.getTextBounds(d, 0, 0, &x1, &y1, &w, &h); //calc width of new string
        int x_start = x - (w / 2);
        int y_start = y - (h / 2)-lineheight/2 + (line*lineheight);
        display.setCursor(x_start, y_start);
        display.print(d);
        d = strtok(NULL, ",");
        if (line == underline_line) {
          display.drawFastHLine(x_start-2, y_start+lineheight-3, w+4, color);
        }
        line++;
    }
    free(tmp);
  }
  return w;
}

int button_multi(const char *buf, int x, int y, int color, int underline_line=0, int lines=0) {
  int16_t x1, y1;
  uint16_t w, h;
  display.setTextColor(color);
  char *tmp = strdup(buf);
  int line = 0;
  char* pch = NULL;
  pch = strtok(tmp, "\n");

  int radius = 2;
  int cell_width = 128/3;
  int left_x = x - (cell_width/2);
  int margin = 10;
  int circle_start_x  = left_x + margin;
  int spacing = (cell_width - margin - margin) / lines;

  while (pch != NULL){
    // Draw Option-Circles
    display.drawCircle(circle_start_x + line*spacing, y+7, radius, SH110X_WHITE);
    // Only display the active text
    if (line == underline_line) {
      display.getTextBounds(pch, 0, 0, &x1, &y1, &w, &h); //calc width of new string
      int x_start = x - (w / 2);
      int y_start = y - (h / 2)-7;
      display.setCursor(x_start, y_start);
      display.print(pch);
      // On the active option, draw a filled circle
      display.fillCircle(circle_start_x + line*spacing, y+7, radius, SH110X_WHITE);
    }
    line++;
    pch = strtok(NULL, "\n");
  }
  free(tmp);
  return w;
}


#endif