# hexmatrix

Hexmatrix is a OSC-controlled 16x16 matrix mixer for the JACK audio system.

![](images/catia.jpg)

A matrix mixer allows you to send any input to any number of outputs. Internal computations are done at 32 bits.



## Usage

1. Start up hexmatrix and patch the jack connections to taste (e.g. using Catia)

2. Send OSC messages to the chosen ip-address and port (see `hexmatrix --help`)

    

The pattern for the OSC addresses is as follows: `/chn/1/send/2 <volume>`. This would set the send volume of input `1` to output `2`. The value `<volume>` should be a float, where a value of `0.0` equals -inf dB, `1.0` equals 0 dB and `8.0` equals roughly +18 dB.

If you are curious how to calculate this: `dB = 20.0 × log10(float)`



## Installation

1. Clone this repository with git
2. Make sure you have rust installed then within the project directory run `cargo build --release`
3. Grab the resulting hexmatrix binary from the `./target` directory
4. Run it
